#Creates a .csv date file for import into Google calendar from export of "Staffelspielplan" webpage from fussball.de
#Licence: The usual GNU GPL 
#Date: July 19, 2012
#Author: Heino Falcke, h.falcke@astro.ru.nl

# Parameters:
# -v team="teamname"   - teamname ist ein eindeutiger Teil des Teamnamens (regexp), um das Team herauszufiltern, dessen Termine man sehen möchte
# -v wo=A oder -v wo=H  - selektiert nur Auswärts- oder Heim-Spiele 
# -v csvfile=Dateiname - Name der Datei mit dem Output im csv Format
# -v duration=hrs      - Länge des Spiels im Kalender
# -v style=style       - Output-Style: EXCEL, CALENDAR  
BEGIN{
    FS="\"\>|\<\/td\>|\<\/*li\>"
    if (team) filter=team
    else filter=""
    
    if (!style) style="CALENDAR"
    if (!filetype) filetype="calendar"
    
    heim=1
    auswaerts=1
    if (wo=="A" || wo=="a") heim=0
    if (wo=="H" || wo=="h") auswaerts=0

    print "Team          : " filter 
    print "Output-Datei  : " csvfile

    nspiel=0
    found=0

    if (style == "CALENDAR") print "Subject,Start Date,Start Time,End Date,End Time,All Day Event,Description,Location,Private" > csvfile
    else if (style == "EXCEL") print "Nr,Spiel,Datum,Paarung,Gegner,Heim,Zeit,Ort" > csvfile
    else if (style == "TEXT") print "" > csvfile
    else print "ERROR: Style " style " ist unbekannt!"
}
/<td class="edDatum/ {
    Datum=$2
    n=split(Datum,a,"[, .]")
    TAG=a[1]
    Tag=a[3]
    Monat=a[4]
    Jahr=a[5]
}
/<td class="edKopfInhalt" id="edSaison/ {Saison=$2; print "Saison        : " Saison}
/<td class="edKopfInhalt" id="edMannschaftsartName/ {Mannschaftsart=$2; print "Mannschaftsart: " Mannschaftsart}
/<td class="edKopfInhalt" id="edSpielklasseName/ {Spielklasse=$2; print "Spielklasse   : " Spielklasse}
/<td class="edKopfInhalt" id="edGebietName/ {Gebiet=$2; print "Gebiet        : " Gebiet}
/<td class="edKopfInhalt" id="edWettbewerbName/ {Wettbewerb=$2; print "Wettbewerb    : " Wettbewerb}
/<td class="edKopfInhalt" id="edWettbewerbID/ {ID=$2; print "ID            : " ID}

/<td class="edSpiel/ {Spiel=$2}
/<td class="edHeim/ {Heim=$2}
/<td class="edGast/ {Gast=$2}
/<td class="edAnstoss/ {Zeit=$2; m=split(Zeit,b,":"); Stunde=b[1]; Minuten=b[2]; numzeit=Stunde+Minuten/60.}
/<td class="edVerlegt/ {Verlegt=$2}
/<td class="zusatzinfoDetail/ {
    n=split($0,a,"\<\/*li\>")
#    print "n=" n
#    print a[n] "-" 
    Ort=a[n-1]; 
    gsub(" *// *",", ",Ort); 
    found=0
    if (heim && match(Heim,filter)) {found="H"; Gegner=Gast}
    if (auswaerts && match(Gast,filter)) {found="A"; Gegner=Heim}
}

(found) {
    nspiel+=1
    if (!Verlegt) {
        if (style == "CALENDAR") print Heim " - " Gast " (" nspiel ". MS - Nr. " Spiel ")" "," Tag "/" Monat "/" Jahr "," Zeit ":00,"Tag "/"  Monat "/" Jahr "," Stunde+2 ":" Minuten ":00,False,\"Meisterschaftsspiel " Mannschaftsart " " Wettbewerb " (" Spielklasse "/" Gebiet ") " "importiert von fussball.de mit fussball2csv (hfa)" " [ID: " ID "-" Spiel "]\"" ",\"" Ort "\",False" >> csvfile
        else if (style == "EXCEL") print nspiel "," Spiel "," Tag "." Monat "." Jahr "," Heim " - " Gast "," Gegner ",(" found ")," Zeit "," "\"" Ort "\""  >> csvfile
        else if (style == "TEXT") print nspiel "\t" Tag "." Monat "." Jahr "\t" Gegner "\t(" found ")\t" Zeit "\t" Ort >> csvfile
    }
    found=0
}

END{
    summary = Mannschaftsart "-" Wettbewerb "-" Saison 
    gsub("[  /]","-",summary)
    print "Zusammenfassung: " summary
}
