/*
 * tsip.h
 *
 * Header file describing Trible Serial Interface Protocol
 *
 * J. Kelley
 * j.kelley@astro.ru.nl
 * August 2009
 */

#define TSIP_DLE  0x10
#define TSIP_ETX  0x03

/* Command packets: user to Resolution T */
#define TSIP_CMD_RESET 0x1E
#define TSIP_CMD_VERS  0x1F
#define TSIP_CMD_SAT   0x24
#define TSIP_CMD_SOFT  0x25
#define TSIP_CMD_SIG   0x27
#define TSIP_CMD_XYZ   0x31
#define TSIP_CMD_LLA   0x32
#define TSIP_CMD_1SAT  0x34
#define TSIP_CMD_IO    0x25
#define TSIP_CMD_STAT  0x37
#define TSIP_CMD_SYS   0x38
#define TSIP_CMD_DSBL  0x39
#define TSIP_CMD_RAW   0x3A
#define TSIP_CMD_TRACK 0x3C
#define TSIP_CMD_CFG   0xBB
#define TSIP_CMD_PORT  0xBC
#define TSIP_CMD_EXT   0x8E

/* Extended commands */
#define TSIP_CMD_EXT_DATE  0x15
#define TSIP_CMD_EXT_SAVE  0x26
#define TSIP_CMD_EXT_MANU  0x41
#define TSIP_CMD_EXT_PROD  0x42
#define TSIP_CMD_EXT_PPS   0x4A
#define TSIP_CMD_EXT_POUT  0x4E
#define TSIP_CMD_EXT_UTC   0xA2
#define TSIP_CMD_EXT_TEST  0xA4
#define TSIP_CMD_EXT_BCST  0xA5
#define TSIP_CMD_EXT_SCMD  0xA6
#define TSIP_CMD_EXT_SPRM  0xA9

/* Report packets: Resolution T to user */
#define TSIP_REP_PERR  0x13
#define TSIP_REP_SXYZ  0x42
#define TSIP_REP_VFIX  0x43
#define TSIP_REP_VERS  0x45
#define TSIP_REP_SIG   0x47
#define TSIP_REP_SLLA  0x4A
#define TSIP_REP_IO    0x55
#define TSIP_REP_VENU  0x56
#define TSIP_REP_CFIX  0x57
#define TSIP_REP_DATA  0x58
#define TSIP_REP_RAW   0x5A
#define TSIP_REP_SAT   0x5C
#define TSIP_REP_VIEW  0x6D
#define TSIP_REP_DXYZ  0x83
#define TSIP_REP_DLLA  0x84
#define TSIP_REP_CFG   0xBB
#define TSIP_REP_PORT  0xBC
#define TSIP_REP_EXT   0x8F

/* Extended reports */
#define TSIP_REP_EXT_DATE  0x15
#define TSIP_REP_EXT_MANU  0x41
#define TSIP_REP_EXT_PROD  0x42
#define TSIP_REP_EXT_PPS   0x4A
#define TSIP_REP_EXT_UTC   0xA2
#define TSIP_REP_EXT_TEST  0xA4
#define TSIP_REP_EXT_POUT  0x4E
#define TSIP_REP_EXT_BCST  0xA5
#define TSIP_REP_EXT_SCMD  0xA6
#define TSIP_REP_EXT_SPRM  0xA9
#define TSIP_REP_EXT_TIME  0xAB
#define TSIP_REP_EXT_STIM  0xAC


