# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

EAPI=4

DESCRIPTION="LAL contains core routines for gravitational-wave data analysis written in ANSI C99."
HOMEPAGE="https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html"
SRC_URI="https://www.lsc-group.phys.uwm.edu/daswg/download/software/source/lalsuite/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="doc"

DEPEND="sci-libs/fftw
		sci-libs/gsl
		sys-libs/zlib
		doc? ( app-text/texlive-core
			dev-texlive/texlive-genericrecommended
			dev-texlive/texlive-fontsrecommended
			dev-texlive/texlive-latexrecommended
			dev-texlive/texlive-latexextra )
	   "
RDEPEND=${DEPEND}

src_compile() {
	emake || die "emake failed"
	use doc && (
		emake dvi || die "emake dvi failed" )
}

pkg_postinst() {
	elog "\n\n    Now you may want to setup your environment:"
	elog "\n    Bourne shell [bash] users: please add the"
	elog "    following lines to your .profile file:"
	elog "\n        . /etc/lal-user-env.sh"
	elog "\n    C-shell [tcsh] users: please add the following"
	elog "    lines to your .login file:"
	elog "\n        source /etc/lal-user-env.csh\n\n"

	use doc && elog "    The LAL documentation can be found in /usr/share/doc/${P}\n\n"
}
