# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

EAPI=4

# Need epatch:
inherit eutils

DESCRIPTION="Handle the Frame data format for the gravitational-wave detectors Virgo and LIGO."
HOMEPAGE="https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html"
SRC_URI="https://www.lsc-group.phys.uwm.edu/daswg/download/software/source/lalsuite/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE=""

DEPEND="=sci-libs/lal-6.5.0
		 sci-libs/lalmetaio
	"
RDEPEND=${DEPEND}

src_prepare() {
	# Fix call to __builtin___snprintf_chk will always overflow destination buffer errors:
	epatch "${FILESDIR}/${P}-NRWaveInject.patch"
}

# sci-libs/lalframe must be UNINSTALLED when lalinspiral is configured(!)
src_configure() {

	# econf doesn't allow || die "...", do warn ahead:
	ewarn "\nNOTE:  sci-libs/lalframe must be UNINSTALLED when lalinspiral is being configured(!)"
	ewarn "If you get the configure error  'Your LALFrame headers do not match your library'"
	ewarn "then this is your problem.  You should uninstall lalframe, install lalinspiral and"
	ewarn "then reinstall lalframe.  Typing:"
	ewarn ""
	ewarn "  emerge -C sci-libs/lalframe && emerge -1 sci-libs/lalinspiral && emerge -1 sci-libs/lalframe"
	ewarn ""
	ewarn "should do this for you.\n"

	econf
}
