# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

EAPI=4

# Need epatch:
inherit eutils

DESCRIPTION="Handle the Frame data format for the gravitational-wave detectors Virgo and LIGO."
HOMEPAGE="http://wwwlapp.in2p3.fr/virgo/FrameL/"
SRC_URI="http://wwwlapp.in2p3.fr/virgo/FrameL/${P}.tar.gz"

LICENSE="freedist"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE=""

DEPEND=""
RDEPEND=${DEPEND}

src_prepare() {
	# Add -soname to linker options:
	epatch "${FILESDIR}/makegcc.patch"
}

src_compile() {
	cd "${S}/mgr"
	./makegcc || die "mgr/makegcc failed"
}

src_install() {
	MYUNAME=`uname`-`uname -m`  # e.g: "Linux-i686"
	cd "${S}"

	dobin ${MYUNAME}/FrCheck ${MYUNAME}/FrCopy ${MYUNAME}/FrDump
	dolib.a ${MYUNAME}/*.a
	dolib.so ${MYUNAME}/*.so*
	dodoc doc/*.html doc/*.pdf

	insinto /usr/include
	doins src/*.h

	insinto /usr/lib/pkgconfig
	doins src/libframe.pc
}
