# Copyright 1999-2012 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

EAPI=4

# Need epatch:
inherit eutils

DESCRIPTION="Handle the Frame data format for the gravitational-wave detectors Virgo and LIGO."
HOMEPAGE="http://wwwlapp.in2p3.fr/virgo/FrameL/"
SRC_URI="http://wwwlapp.in2p3.fr/virgo/FrameL/${P}.tar.gz"

LICENSE="freedist"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE=""

DEPEND=""
RDEPEND=${DEPEND}

MY_TMPDIR=`uname`-`uname -m`  # Temporary directory in which the binaries will be installed, e.g: "Linux-i686"

src_prepare() {
	# Add -soname to linker options:
	MY_PMV=`echo ${PV} | sed -e 's/\..*//'`  # PMV: Package Major Version number, e.g. libframe-8.15 -> 8
	sed -i -e 's/-fPIC -o libFrame\.so/-fPIC -Wl,-soname,libFrame.so.'${MY_PMV}' -o libFrame.so.'${PV}'/' mgr/makegcc

	# 'Fix' libframe.pc - for some reason, "Libs: -L/usr/lib{...} -lFrame" doesn't work,
	# "Libs: /usr/lib{...}/libFrame.so" does...
	epatch "${FILESDIR}/libframe.pc.in.patch"
}

src_compile() {
	cd mgr/
	./makegcc || die "mgr/makegcc failed"
	cd -
}

src_install() {
	# Create .so symlinks:
	cd ${MY_TMPDIR}
	MY_PMV=`echo ${PV} | sed -e 's/\..*//'`  # PMV: Package Major Version number, e.g. libframe-8.15 -> 8
	ln -sv libFrame.so.${PV} libFrame.so.${MY_PMV}
	ln -sv libFrame.so.${MY_PMV} libFrame.so
	cd -

	dobin ${MY_TMPDIR}/FrCheck ${MY_TMPDIR}/FrCopy ${MY_TMPDIR}/FrDump
	dolib.a ${MY_TMPDIR}/*.a
	dolib.so ${MY_TMPDIR}/libFrame.so*
	dodoc doc/*.html doc/*.pdf

	insinto /usr/include
	doins src/*.h

	# Without this, configure doesn't find the LIBFRAME package, but does find its contents
	# With this, configure finds the LIBFRAME package, but not its contents...(?), which seems worse
	insinto /usr/lib/pkgconfig
	doins src/libframe.pc
}
